/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.items;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.NBTTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbuilder.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;

public class VehicleCard
extends Item
implements ITooltipSettings {
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.parameter((String)"name", VehicleCard::getVehicleName), TooltipBuilder.parameter((String)"destination", VehicleCard::isMoving, VehicleCard::getDesiredDestinationName), TooltipBuilder.parameter((String)"contents", VehicleCard::getContentsDescription)});

    public VehicleCard() {
        super(Registration.createStandardProperties().m_41487_(1));
    }

    public static String getVehicleName(ItemStack stack) {
        return NBTTools.getString((ItemStack)stack, (String)"vehicleName", (String)"<unknown>");
    }

    private static String getContentsDescription(ItemStack stack) {
        Map<BlockState, List<BlockPos>> blocks = VehicleCard.getBlocks(stack, BlockPos.f_121853_);
        int cnt = 0;
        for (List<BlockPos> list : blocks.values()) {
            cnt += list.size();
        }
        return cnt + " blocks";
    }

    public void m_7373_(@Nonnull ItemStack itemStack, Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), itemStack, list, flag);
    }

    public static void storeVehicleInCard(ItemStack vehicleCard, Map<BlockState, List<Integer>> blocks, String vehicleName) {
        ListTag list = new ListTag();
        blocks.forEach((state, positions) -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("state", (Tag)NbtUtils.m_129202_((BlockState)state));
            tag.m_128408_("blocks", positions);
            list.add((Object)tag);
        });
        vehicleCard.m_41784_().m_128365_("blocks", (Tag)list);
        vehicleCard.m_41784_().m_128359_("vehicleName", vehicleName);
    }

    public static void setDesiredDestination(ItemStack vehicleCard, BlockPos pos, String name) {
        vehicleCard.m_41784_().m_128385_("desiredPos", new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
        vehicleCard.m_41784_().m_128359_("desiredPosName", name);
    }

    public static void clearDesiredDestination(ItemStack vehicleCard) {
        vehicleCard.m_41784_().m_128473_("desiredPos");
        vehicleCard.m_41784_().m_128473_("desiredPosName");
    }

    @Nullable
    public static BlockPos getDesiredDestination(ItemStack vehicleCard) {
        CompoundTag tag = vehicleCard.m_41783_();
        if (tag == null) {
            return null;
        }
        if (tag.m_128441_("desiredPos")) {
            int[] desiredPos = tag.m_128465_("desiredPos");
            return new BlockPos(desiredPos[0], desiredPos[1], desiredPos[2]);
        }
        return null;
    }

    private static boolean isMoving(ItemStack vehicleCard) {
        CompoundTag tag = vehicleCard.m_41783_();
        if (tag == null) {
            return false;
        }
        return tag.m_128441_("desiredPosName");
    }

    @Nullable
    public static String getDesiredDestinationName(ItemStack vehicleCard) {
        CompoundTag tag = vehicleCard.m_41783_();
        if (tag == null) {
            return null;
        }
        if (tag.m_128441_("desiredPosName")) {
            return tag.m_128461_("desiredPosName");
        }
        return null;
    }

    public static Map<BlockState, List<BlockPos>> getBlocks(ItemStack vehicleCard, BlockPos minPos) {
        HashMap<BlockState, List<BlockPos>> result = new HashMap<BlockState, List<BlockPos>>();
        CompoundTag compoundTag = vehicleCard.m_41783_();
        if (compoundTag != null) {
            ListTag list = compoundTag.m_128437_("blocks", 10);
            for (Tag tag : list) {
                CompoundTag c = (CompoundTag)tag;
                BlockState state = NbtUtils.m_129241_((CompoundTag)c.m_128469_("state"));
                int[] blocks = c.m_128465_("blocks");
                List blockPosList = Arrays.stream(blocks).mapToObj(i -> VehicleCard.convertIntToPos(minPos, i)).collect(Collectors.toList());
                result.put(state, blockPosList);
            }
        }
        return result;
    }

    public static int convertPosToInt(BlockPos min, BlockPos current) {
        int dx = current.m_123341_() - min.m_123341_();
        int dy = current.m_123342_() - min.m_123342_();
        int dz = current.m_123343_() - min.m_123343_();
        return dx << 20 | dy << 10 | dz;
    }

    public static BlockPos convertIntToPos(BlockPos min, int current) {
        return new BlockPos(min.m_123341_() + (current >> 20 & 0x3F), min.m_123342_() + (current >> 10 & 0x3F), min.m_123343_() + (current & 0x3F));
    }
}

